#!/bin/bash

for source_file in $(ls */[1-9]_*.tex)
do
    filename=${source_file##*/}
    echo $filename
    cd ${source_file%/*}
    tail -n +2 $filename > tmp.tex
    cat ../header_handout.tex tmp.tex | pdflatex
    pdfnup --nup 2x3 --suffix '2x3' --no-landscape --a4paper --delta "1 10" texput.pdf 
    cp texput-2x3.pdf ${filename%.tex}-2x3.pdf

    cat ../header_slides.tex tmp.tex | pdflatex
    cp texput.pdf ${filename%.tex}.pdf
    cd ..
done
